﻿Enumeration
  #Window_0
EndEnumeration

Enumeration
  #Text_0
  #Combo_0
  #Checkbox_0
  #Container_0
  #Checkbox_1
  #Checkbox_2
  #Checkbox_3
  #Checkbox_4
  #Checkbox_5
  #Checkbox_6
  #Checkbox_7
  #Checkbox_8
  #Button_0
EndEnumeration

Enumeration
  #Port_0
EndEnumeration

#Pin_Data  = #PB_SerialPort_RTS ; Вывод данных.
#Pin_SCL   = #PB_SerialPort_DTR ; Вывод тактовых импульсов.
#Pin_Write = #PB_SerialPort_TXD ; Вывод записи в регистр.

Macro SetPinState(Pin, State)
  SetSerialPortStatus(#Port_0, Pin, (State ! Invert) & 1)
EndMacro

Procedure Send()
  Protected PortName.s, Invert
  Protected i
  
  PortName = GetGadgetText(#Combo_0)
  Invert   = GetGadgetState(#Checkbox_0) & 1
  
  If OpenSerialPort(#Port_0, PortName, 9600, #PB_SerialPort_NoParity, 8, 1, #PB_SerialPort_NoHandshake, 255, 255)
    
    For i=7 To 0 Step -1
      SetPinState(#Pin_Data, GetGadgetState(#Checkbox_1+i))
      Delay(10)
      SetPinState(#Pin_SCL, 1)
      Delay(10)
      SetPinState(#Pin_SCL, 0)
      Delay(10)
    Next i
    
    SetPinState(#Pin_Write, 1)
    Delay(10)
    SetPinState(#Pin_Write, 0)
    Delay(10)
    
    CloseSerialPort(#Port_0)
  Else
    MessageRequester("", "Не удалось открыть порт "+PortName)
  EndIf
  
EndProcedure


Procedure OpenWindow_0(x = 0, y = 0, width = 216, height = 228)
  Protected i
  
  OpenWindow(#Window_0, x, y, width, height, "COM to 74HC595", #PB_Window_SystemMenu | #PB_Window_MinimizeGadget | #PB_Window_ScreenCentered)
  TextGadget(#Text_0, 8, 12, 36, 16, "Порт")
  ComboBoxGadget(#Combo_0, 44, 8, 92, 20)
  GadgetToolTip(#Combo_0, "COM порт к которому подключено устройство")
  
  For i=1 To 10
    AddGadgetItem(#Combo_0, -1, "COM"+Str(i))
  Next i
  
  SetGadgetState(#Combo_0, 0)
  
  CheckBoxGadget(#Checkbox_0, 8, 32, 108, 16, "Инвертировать")
  GadgetToolTip(#Checkbox_0, "Инвертировать состояние выходов порта")
  ContainerGadget(#Container_0, 0, 52, 212, 176)
  
  For i=0 To 7
    CheckBoxGadget(#Checkbox_1+i, 8, 8+i*20, 80, 16, "Led "+Str(i+1))
  Next i
  
  ButtonGadget(#Button_0, 124, 136, 84, 28, "Отправить")
  GadgetToolTip(#Button_0, "Отправить данные в COM порт")
  CloseGadgetList()
  
EndProcedure

OpenWindow_0()

Repeat
  Event = WaitWindowEvent()
  
  If Event = #PB_Event_Gadget
    Select EventGadget()
      Case #Button_0
        Send()
    EndSelect
  EndIf
  
Until Event = #PB_Event_CloseWindow

; IDE Options = PureBasic 5.31 (Windows - x64)
; CursorPosition = 29
; FirstLine = 19
; Folding = -
; EnableUnicode
; EnableXP
; Executable = COM to 74HC595 x64.exe